/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.gelato_galore.reload;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class FlavorData {
    public static int CURRENT_MAX_ID = 0;
    public static final Codec<FlavorData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(FlavorData::getId), (App)Codec.STRING.fieldOf("name").forGetter(FlavorData::getName), (App)Codec.INT.optionalFieldOf("color", (Object)0).forGetter(FlavorData::getColor), (App)FlavorEffect.CODEC.optionalFieldOf("effect", null).forGetter(FlavorData::getEffect), (App)Codec.INT.optionalFieldOf("patternId", (Object)0).forGetter(FlavorData::getPatternId), (App)Codec.INT.optionalFieldOf("patternColor", (Object)0).forGetter(FlavorData::getPatternColor), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("requiredMods", new ArrayList()).forGetter(FlavorData::getRequiredMods)).apply((Applicative)instance, FlavorData::new));
    public ResourceLocation id;
    public String name;
    public int color;
    public FlavorEffect effect;
    public int patternId;
    public int patternColor;
    public List<String> requiredMods;

    public FlavorData(ResourceLocation id, String name, int color, FlavorEffect instance, int patternId, int patternColor, List<String> requiredMods) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.effect = instance;
        this.patternId = patternId;
        this.patternColor = patternColor;
        this.requiredMods = requiredMods;
    }

    public FlavorData(ResourceLocation id, String name, int color, ResourceLocation location, int duration, int amplifier, int patternId, int patternColor, List<String> requiredMods) {
        this.id = id;
        this.name = name;
        this.color = color;
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(location);
        if (effect != null) {
            this.effect = new FlavorEffect(effect, duration, amplifier);
        }
        this.patternId = patternId;
        this.patternColor = patternColor;
        this.requiredMods = requiredMods;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public FlavorEffect getEffect() {
        return this.effect;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public int getPatternColor() {
        return this.patternColor;
    }

    public List<String> getRequiredMods() {
        return this.requiredMods;
    }

    public Color getAsColor() {
        String hexColor = String.format("#%06X", 0xFFFFFF & this.color);
        Color color = Color.decode(hexColor);
        return color;
    }

    public static FlavorData deserialize(JsonObject json, ResourceLocation origin) {
        String effectStr;
        ResourceLocation location;
        if (!json.isJsonObject()) {
            throw new JsonParseException("FlavorData must be a JSON Object");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList<String> requiredMods = new ArrayList<String>();
        JsonArray jsonModList = GsonHelper.m_13832_((JsonObject)jsonObject, (String)"requiredMods", (JsonArray)new JsonArray());
        for (Object element : jsonModList) {
            requiredMods.add(element.getAsString());
        }
        boolean supportedModsLoaded = false;
        for (String mod : requiredMods) {
            if (ModList.get().isLoaded(mod)) continue;
            supportedModsLoaded = true;
        }
        if (supportedModsLoaded) {
            return null;
        }
        String name = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"name", null);
        if (name == null) {
            throw new JsonParseException("name is not valid");
        }
        int color = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"color", (int)0);
        if (color < 0) {
            throw new JsonParseException("color is not valid");
        }
        JsonElement effectElement = json.get("effectInstance");
        FlavorEffect instance = null;
        if (effectElement != null && (location = ResourceLocation.m_135820_((String)((effectStr = GsonHelper.m_13851_((JsonObject)effectElement.getAsJsonObject(), (String)"effect", null)) != null ? effectStr : ""))) != null) {
            int duration = GsonHelper.m_13824_((JsonObject)effectElement.getAsJsonObject(), (String)"duration", (int)900);
            int amplifier = GsonHelper.m_13824_((JsonObject)effectElement.getAsJsonObject(), (String)"amplifier", (int)0);
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(location);
            instance = new FlavorEffect(effect != null ? effect : MobEffects.f_19596_, duration, amplifier);
        }
        int patternId = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"patternId", (int)0);
        int patternColor = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"patternColor", (int)color);
        return new FlavorData(origin, name, color, instance, patternId, patternColor, requiredMods);
    }

    public static class FlavorEffect {
        private final MobEffect effect;
        public int duration;
        private int amplifier;
        public static final Codec<FlavorEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("effect").forGetter(FlavorEffect::getEffect), (App)Codec.INT.optionalFieldOf("duration", (Object)900).forGetter(FlavorEffect::getDuration), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(FlavorEffect::getAmplifier)).apply((Applicative)instance, FlavorEffect::new));

        public FlavorEffect(MobEffect p_19513_) {
            this(p_19513_, 0, 0);
        }

        public FlavorEffect(MobEffect p_19515_, int p_19516_) {
            this(p_19515_, p_19516_, 0);
        }

        public FlavorEffect(MobEffect p_216887_, int p_216888_, int p_216889_) {
            this.effect = p_216887_;
            this.duration = p_216888_;
            this.amplifier = p_216889_;
        }

        public MobEffectInstance construct() {
            return new MobEffectInstance(this.effect, this.duration, this.amplifier);
        }

        public MobEffectInstance constructModified(int durationMod, int amplifierMod) {
            return new MobEffectInstance(this.effect, this.duration + durationMod, this.amplifier + amplifierMod);
        }

        public MobEffect getEffect() {
            return this.effect;
        }

        public int getDuration() {
            return this.duration;
        }

        public int getAmplifier() {
            return this.amplifier;
        }
    }
}

